/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jsidplay;

import com.dreamfabric.jac64.AudioDriver;
import com.dreamfabric.jac64.CIA;
import com.dreamfabric.jac64.ExtChip;
import com.dreamfabric.jac64.RESIDChip;
import com.dreamfabric.jac64.SIDChip;
import com.dreamfabric.jsidplay.JSCPU;
import com.dreamfabric.jsidplay.JSIDListener;

public class JSIDChipemu
extends ExtChip {
    public static final int IO_OFFSET = 12288;
    public static final boolean IRQDEBUG = false;
    public static final int RESID_6581 = 1;
    public static final int RESID_8580 = 2;
    public static final int JACSID = 3;
    public static final int IO_UPDATE = 57;
    public static final int SCAN_RATE_VICII = 63;
    public static final int SCAN_RATE_VICII_NTSC = 65;
    public static final int SCAN_LINES_PAL = 312;
    public static final int SCAN_LINES_NTSC = 263;
    private long nextScanLine = 0L;
    private int scanLines = 312;
    private int scanRate = 63;
    ExtChip sidChip;
    private int[] memory;
    JSCPU cpu;
    CIA[] cia;
    int irqMask = 0;
    int irqFlags = 0;
    private boolean timersOn = true;
    private boolean pause = false;
    private boolean ready = false;
    int reads = 0;
    JSIDListener listener = null;
    AudioDriver audioDriver;
    private static final int[] IO_ADDRAND = new int[]{53311, 53311, 53311, 53311, 54303, 54303, 54303, 54303, 55551, 55807, 56063, 56319, 56335, 56591, 57087, 57343};
    public int[] vicMemory = new int[4096];
    int frq;
    int vbeam = 0;
    boolean updating = false;
    long nextSID = 0L;
    int rnd;
    long oldcyc;
    float sleep = 2.0f;
    float percent = 0.0f;
    int mes = 0;
    int trigger = 0;
    int frame = 0;

    public void setSID(int sid) {
        switch (sid) {
            case 1: 
            case 2: {
                if (!(this.sidChip instanceof RESIDChip)) {
                    if (this.sidChip != null) {
                        this.sidChip.stop();
                    }
                    this.sidChip = new RESIDChip(this.cpu, this.audioDriver);
                }
                ((RESIDChip)this.sidChip).setChipVersion(sid);
                break;
            }
            case 3: {
                if (this.sidChip instanceof SIDChip) break;
                if (this.sidChip != null) {
                    this.sidChip.stop();
                }
                this.sidChip = new SIDChip(this.cpu, this.audioDriver);
            }
        }
    }

    public void init(int[] memory, JSCPU cpu, JSIDListener listener, AudioDriver driver) {
        super.init(cpu);
        this.listener = listener;
        this.cia = new CIA[2];
        this.cia[0] = new CIA(cpu, 68608, this);
        this.cia[1] = new CIA(cpu, 68864, this);
        this.memory = memory;
        this.cpu = cpu;
        this.audioDriver = driver;
        this.setSID(1);
    }

    public void setPAL(boolean pal) {
        if (pal) {
            this.scanLines = 312;
            this.scanRate = 63;
        } else {
            this.scanLines = 263;
            this.scanRate = 65;
        }
    }

    public void clearTimers() {
        this.cia[0].reset();
        this.cia[1].reset();
    }

    public void setPause(boolean stat) {
        this.pause = stat;
    }

    public void dumpStatus() {
        this.cia[0].printStatus();
        this.cia[1].printStatus();
    }

    @Override
    public int performRead(int address, long cycles) {
        int pos = address >> 8 & 0xF;
        int val = this.memory[(address &= IO_ADDRAND[pos]) + 12288];
        switch (address) {
            case 53273: {
                return this.irqFlags;
            }
            case 53274: {
                return this.irqMask;
            }
        }
        if (pos == 13) {
            return this.cia[1].performRead(address + 12288, cycles);
        }
        if (pos == 12) {
            return this.cia[0].performRead(address + 12288, cycles);
        }
        return val;
    }

    @Override
    public void performWrite(int address, int data, long cycles) {
        int pos = address >> 8 & 0xF;
        int old = this.memory[address];
        this.memory[address + 12288] = data;
        this.notifyWrite(address + 12288, old);
    }

    public void setCurrentMemory(int[] currMemory) {
        this.memory = currMemory;
    }

    public boolean isReady() {
        return this.ready;
    }

    @Override
    public void stop() {
    }

    @Override
    public void reset() {
        this.ready = false;
        this.reads = 0;
        this.irqMask = 0;
        this.irqFlags = 0;
        this.timersOn = true;
        this.sidChip.reset();
        System.out.println("SIDS reset...");
    }

    public void notifyWrite(int address, int oldData) {
        long cycles = this.cpu.getCycles();
        int data = this.memory[address];
        if (address >= 66560 && address < 66816) {
            this.sidChip.performWrite(address & 0xFFF1F, data, cycles);
        }
        switch (address) {
            case 65553: {
                this.vicMemory[17] = data;
                this.memory[65553] = this.memory[65553] & 0x7F | (this.vbeam & 0x100) >> 1;
                break;
            }
            case 65554: {
                this.vicMemory[18] = data;
                this.memory[address] = this.vbeam & 0xFF;
                break;
            }
            case 65561: {
                if ((data & 0x80) != 0) {
                    data = 255;
                }
                int latchval = 0xFF ^ data;
                this.irqFlags &= latchval;
                this.vicMemory[25] = this.vicMemory[25] & latchval;
                this.memory[address] = this.vicMemory[25];
                if ((this.vicMemory[25] & 0xF & this.vicMemory[26]) != 0) break;
                this.clearIRQ(1);
                break;
            }
            case 65562: {
                this.irqMask = data;
                if ((this.irqMask & 0xF & this.irqFlags) != 0) {
                    this.irqFlags |= 0x80;
                    this.setIRQ(1);
                    break;
                }
                this.clearIRQ(1);
                break;
            }
            case 68608: 
            case 68609: {
                if (!this.ready && this.reads++ > 20) {
                    System.out.println("CPU Ready!!");
                    this.ready = true;
                    this.reads = 0;
                }
            }
            case 68610: 
            case 68611: 
            case 68612: 
            case 68613: 
            case 68614: 
            case 68615: 
            case 68616: 
            case 68617: 
            case 68618: 
            case 68619: 
            case 68620: 
            case 68621: 
            case 68622: 
            case 68623: {
                this.cia[0].performWrite(address, data, cycles);
                break;
            }
            case 68864: 
            case 68865: 
            case 68866: 
            case 68867: 
            case 68868: 
            case 68869: 
            case 68870: 
            case 68871: 
            case 68872: 
            case 68873: 
            case 68874: 
            case 68875: 
            case 68876: 
            case 68877: 
            case 68878: 
            case 68879: {
                this.cia[1].performWrite(address, data, cycles);
            }
        }
    }

    @Override
    public void clock(long cycles) {
        if (this.nextScanLine <= cycles) {
            this.vicTic(cycles);
            this.nextScanLine += (long)this.scanRate;
        }
    }

    public void enableTimers(boolean on) {
        System.out.println("ENABLE_TIMERS: " + on);
        this.timersOn = on;
    }

    public int vicTic(long cycles) {
        int irqLatch = this.vicMemory[25];
        boolean irq = false;
        if (this.vbeam == 311) {
            if (!this.timersOn) {
                this.memory[65561] = this.memory[65561] | 1;
            }
            if (this.listener != null) {
                this.listener.screenRefresh();
            }
            irq = true;
        }
        if (this.timersOn) {
            irq = false;
        }
        irq = this.vbeam == 310;
        this.memory[65561] = irq ? this.memory[65561] | 0x81 : 0;
        this.memory[66587] = this.rnd++ & 0xFF;
        this.memory[65554] = this.vbeam & 0xFF;
        this.memory[65553] = this.memory[65553] & 0x7F | (this.vbeam & 0x100) >> 1;
        int irqComp = ((this.vicMemory[17] & 0x80) << 1) + this.vicMemory[18];
        if (irqComp > 312) {
            irqComp &= 0xFF;
        }
        if ((this.irqFlags & 1) == 0 && irqComp == this.vbeam) {
            this.irqFlags |= 1;
            if ((this.irqMask & 1) != 0) {
                this.irqFlags |= 0x80;
                this.setIRQ(1);
            }
        }
        this.vbeam = (this.vbeam + 1) % this.scanLines;
        if (this.vbeam == 0) {
            ++this.frame;
        }
        return 0;
    }
}

